from sklearn.cluster import kmeans_plusplus
import numpy as np
from sklearn.metrics import pairwise_distances_argmin_min as dist

import math
import random

def cost(data, centers):
    # Calculate the clustering cost based on the sum of squared distances from each point to its nearest center times its weight
    _, distance = dist(data, centers)
    result = np.sum(distance)
    return result

def center_fixed_local_search_01_uniform(data, k, s=1, n_iter=10):
    indices = np.random.choice(data.shape[0], size=k, replace=False)
    centers = data[indices]
    for i in range(k * n_iter):
        current_cost = cost(data, centers)
        new_centers = np.copy(centers)
        center_idx = random.randint(1, len(centers) - 1)
        data_idx = random.randint(0, len(data) - 1)
        new_centers[center_idx] = data[data_idx]

        new_cost = cost(data, new_centers)
        if new_cost < current_cost:
            centers = new_centers

    assignment, distance = dist(data, centers)
    current_cost = cost(data, centers)

    return current_cost, centers, assignment

def k_medoids_algorithm_uniform(data, k, s=1, attempt = 1000, n_iter=10):
    current_cost, current_centers, current_assignment = center_fixed_local_search_01_uniform(data, k, s, n_iter)
    for i in range(attempt):
        new_cost, new_centers, new_assignment = center_fixed_local_search_01_uniform(data, k, s, n_iter)
        if new_cost < current_cost:
            current_cost = new_cost
            current_centers = new_centers
            current_assignment = new_assignment
        
    return current_cost, current_centers, current_assignment